(function($) {
  'use strict';
  $(function() {
	
	var salesanalyticData = {
    labels: ["Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug"],
    datasets: [{
            label: 'Critical',
            data: [24, 23, 22, 24, 26, 23, 28],
            borderColor: [
                '#3022cb'
            ],
            borderWidth: 3,
            fill: false,
        },
        {
            label: 'Warning',
            data: [26, 27, 26, 22, 25, 26, 24],
            borderColor: [
                '#ff8300',
            ],
            borderWidth: 3,
            fill: false,
        },
        {
            label: 'Error',
            data: [25, 28, 24, 28, 29, 27, 25],
            borderColor: [
                '#f2125e',
            ],
            borderWidth: 3,
            fill: false,
        }
    ],
  };
  var salesanalyticOptions = {
      scales: {
          yAxes: [{
              display: true,
              gridLines: {
                drawBorder: false,
                display: true,
            },
              ticks: {
                display: false,
                beginAtZero: false,
                stepSize: 5
              }
          }],
          xAxes: [{
            display: true,
              position: 'bottom',
              gridLines: {
                  drawBorder: false,
                  display: false,
              },
              ticks: {
                display: true,
                beginAtZero: true,
                stepSize: 5
              }
          }],

      },
      legend: {
          display: false,
          labels: {
            boxWidth: 0,
          }
      },
      elements: {
          point: {
              radius: 0
          },
          line: {
            tension: .4,
        },
      },
      tooltips: {
          backgroundColor: 'rgba(2, 171, 254, 1)',
      }
  };
  
	  if ($("#salesanalyticChart").length) {
    var lineChartCanvas = $("#salesanalyticChart").get(0).getContext("2d");
    var saleschart = new Chart(lineChartCanvas, {
        type: 'line',
        data: salesanalyticData,
        options: salesanalyticOptions
    });
  }
  

  
 if ($("#salesTopChart").length) {
    var graphGradient = document.getElementById("salesTopChart").getContext('2d');;
    var saleGradientBg = graphGradient.createLinearGradient(25, 0, 25, 110);
    saleGradientBg.addColorStop(0, 'rgba(242,18,94, 1)');
    saleGradientBg.addColorStop(1, 'rgba(255, 255, 255, 1)');
    var salesTopData = {
        labels: [
        "Feb 1",
        "Feb 2",
        "Feb 3",
        "Feb 4",
        "Feb 5",
        "Feb 6",
        "Feb 7",
        "Feb 8",
        "Feb 9",
        "Feb 10",
        "Feb 11",
        "Feb 12",
        "Feb 13",
        "Feb 14",
        "Feb 15",
        "Feb 16",
        "Feb 17",
        "Feb 18",
        "Feb 19",
        "Feb 20",
        "Feb 21",
        "Feb 22",
        "Feb 23",
        "Feb 24",
        "Feb 25",
        "Feb 26",
        "Feb 27",
        "Feb 28",
        "Mar 1",
        "Mar 2",
        "Mar 3",
        "Mar 4",
        "Mar 5",
        "Mar 6",
        "Mar 7",
        "Mar 8",
        "Mar 9",
        "Mar 10",
        ],
        datasets: [{
            label: '# of Votes',
            data: [80, 79, 78, 65, 77, 68, 63, 73, 58, 46, 60, 65, 74, 72, 63, 54, 55, 64, 34, 46, 34, 35, 24, 64, 34, 23, 13, 54, 27, 43, 34, 43, 64, 50, 43, 55, 39, 43],
            backgroundColor: saleGradientBg,
            borderColor: [
                'rgba(242,18,94)',
            ],
            borderWidth: 2,
            fill: true, 
        }]
    };

    var salesTopOptions = {
        scales: {
            yAxes: [{
              display: true,
                gridLines: {
                    display: true,
                    drawBorder: true,
                },
                ticks: {
                  display: false,
                  beginAtZero: true,
                }
            }],
            xAxes: [{
              display: true,
                gridLines: {
                    display: true,
                    drawBorder: false,
                },
                ticks: {
                    beginAtZero: true,
                    maxTicksLimit: 4,
                    maxRotation: 360,
                    minRotation: 360,
                    padding: 10
                }
            }],
        },
        legend: {
            display: false
        },
        elements: {
          point: {
            radius: 0
        },
            line: {
                tension: 0.1,
            }
        },
        tooltips: {
            backgroundColor: 'rgba(31, 59, 179, 1)',
        }
    }
    var salesTop = new Chart(graphGradient, {
        type: 'line',
        data: salesTopData,
        options: salesTopOptions
    });
}


  });
})(jQuery);